package gov.va.med.mhv.vitals.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.springframework.stereotype.Component;

import gov.va.med.mhv.common.api.exception.MHVException;
import gov.va.med.mhv.common.api.util.ResponseUtil;
import gov.va.med.mhv.vitals.dto.BloodPressureReadingDTO;
import gov.va.med.mhv.vitals.dto.BloodSugarReadingDTO;
import gov.va.med.mhv.vitals.dto.BodyTemperatureDTO;
import gov.va.med.mhv.vitals.dto.BodyWeightReadingDTO;
import gov.va.med.mhv.vitals.dto.HeartRateReadingDTO;
import gov.va.med.mhv.vitals.dto.InrReadingDTO;
import gov.va.med.mhv.vitals.dto.LipidsReadingDTO;
import gov.va.med.mhv.vitals.dto.PainReadingDTO;
import gov.va.med.mhv.vitals.dto.PulseOximetryReadingDTO;
import gov.va.med.mhv.vitals.dto.VitalSignsSummaryDTO;
import gov.va.med.mhv.vitals.service.VitalSignsService;

@Component
public class VitalSignsServiceImpl implements VitalSignsService {
	
	@Resource
	private BloodPressureServiceImpl bloodPressureService;
	
	@Resource
	private BloodSugarServiceImpl bloodSugarService;
	
	@Resource
	private BodyTemperatureServiceImpl bodyTemperatureService;
	
	@Resource
	private BodyWeightServiceImpl bodyWeightService;
	
	@Resource
	private HeartRateServiceImpl heartRateService;
	
	@Resource
	private InrServiceImpl inrService;
	
	@Resource
	private LipidsServiceImpl lipidsService;
	
	@Resource
	private PainServiceImpl painService;
	
	@Resource
	private PulseOximetryServiceImpl pulseOximetryService;

	public VitalSignsSummaryDTO getVitalSignsSummary(Long userProfileId) throws MHVException {
		
		VitalSignsSummaryDTO summary = new VitalSignsSummaryDTO();
		
		summary.setUserProfileId(userProfileId);
		
		summary.setBloodPreassureReadings(this.bloodPressureService.getBPDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setBloodSugarReadings(this.bloodSugarService.getBloodSugarDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setBodyTemperatureReadings(this.bodyTemperatureService.getTemperatureDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setBodyWeightReadings(this.bodyWeightService.getBWDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setHeartRateReadings(this.heartRateService.getHeartRateDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setInrReadings(this.inrService.getInrDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setLipidReadings(this.lipidsService.getLipidDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setPainReadings(this.painService.getPainDashBoardReadingsForUser(userProfileId).getPojoObject());
		summary.setPulseOximetryReadings(this.pulseOximetryService.getPulseOximetryDashBoardReadingsForUser(userProfileId).getPojoObject());
		
		return summary;
	}

	@Override
	public Long saveBloodPressureReading(BloodPressureReadingDTO bpDTO) throws MHVException {
		ResponseUtil<Long> response = null;
		
		try {
			response = this.bloodPressureService.save(bpDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while saving the blood pressure reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteBloodPressureReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.bloodPressureService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the blood pressure reading.", ex);
		}
	}

	@Override
	public List<BloodPressureReadingDTO> getBloodPressureReadingsForUser(Long userProfileId) throws MHVException {
		ResponseUtil<List<BloodPressureReadingDTO>> response = null;
		
		try {
			response = this.bloodPressureService.getBPReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the blood pressure readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public BloodPressureReadingDTO getBloodPressureReadingById(Long userProfileId, Long id) throws MHVException {
		try {
			return this.bloodPressureService.getBPReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the blood pressure reading.", ex);
		}
	}

	@Override
	public Long saveBloodSugarReading(BloodSugarReadingDTO bloodSugarDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.bloodSugarService.save(bloodSugarDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the blood sugar reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteBloodSugarReading(Long userProfileId, Long id) throws MHVException {
		
		try {
			this.bloodSugarService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the blood sugar reading.", ex);
		}
	}

	@Override
	public List<BloodSugarReadingDTO> getBloodSugarReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<BloodSugarReadingDTO>> response = null;
		
		try {
			response = this.bloodSugarService.getBloodSugarReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the blood sugar readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public BloodSugarReadingDTO getBloodSugarReadingBy(Long userProfileId, Long id) throws MHVException {
		try {
			return this.bloodSugarService.getBloodSugarReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the blood sugar reading.", ex);
		}
	}

	@Override
	public Long saveBodyTemperatureReading(BodyTemperatureDTO bodyTemperatureDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.bodyTemperatureService.save(bodyTemperatureDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the body temperature reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteBodyTemperatureReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.bodyTemperatureService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the body temperature reading.", ex);
		}
		
	}

	@Override
	public List<BodyTemperatureDTO> getTemperatureReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<BodyTemperatureDTO>> response = null;
		
		try {
			response = this.bodyTemperatureService.getTemperatureReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the temperature readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public BodyTemperatureDTO getTemperatureReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.bodyTemperatureService.getTemperatureReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the temperature reading.", ex);
		}
	}

	@Override
	public Long saveBodyWeightReading(BodyWeightReadingDTO bwDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.bodyWeightService.save(bwDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the body weigth reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteBodyWeightReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.bodyWeightService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the body weight reading.", ex);
		}
		
	}

	@Override
	public List<BodyWeightReadingDTO> getBWReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<BodyWeightReadingDTO>> response = null;
		
		try {
			response = this.bodyWeightService.getBWReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the body weigth readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public BodyWeightReadingDTO getBWReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.bodyWeightService.getBWReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the body weight reading.", ex);
		}
	}

	@Override
	public Long saveHeartRateReading(HeartRateReadingDTO heartRateDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.heartRateService.save(heartRateDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the heart rate reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteHeartRateReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.heartRateService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the heart rate reading.", ex);
		}
	}

	@Override
	public List<HeartRateReadingDTO> getHeartRateReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<HeartRateReadingDTO>> response = null;
		
		try {
			response = this.heartRateService.getHeartRateReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the heart rate readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public HeartRateReadingDTO getHeartRateReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.heartRateService.getHeartRateReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the heart rate reading.", ex);
		}
	}

	@Override
	public Long saveInrReading(InrReadingDTO inrDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.inrService.save(inrDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the INR reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteInrReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.inrService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the INR reading.", ex);
		}
	}

	@Override
	public List<InrReadingDTO> getInrReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<InrReadingDTO>> response = null;
		
		try {
			response = this.inrService.getInrReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the INR readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public InrReadingDTO getINRReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.inrService.getINRReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the INR reading.", ex);
		}
	}

	@Override
	public Long saveLipidsReading(LipidsReadingDTO lipidDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.lipidsService.save(lipidDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the lipids reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deleteLipidsReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.lipidsService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the lipids reading.", ex);
		}
	}

	@Override
	public List<LipidsReadingDTO> getLipidReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<LipidsReadingDTO>> response = null;
		
		try {
			response = this.lipidsService.getLipidReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the lipids readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public LipidsReadingDTO getLipidReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.lipidsService.getLipidReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the lipids reading.", ex);
		}
	}

	@Override
	public Long savePainReading(PainReadingDTO painDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.painService.save(painDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pain reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deletePainReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.painService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the pain reading.", ex);
		}
	}

	@Override
	public List<PainReadingDTO> getPainReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<PainReadingDTO>> response = null;
		
		try {
			response = this.painService.getPainReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pain readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public PainReadingDTO getPainReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.painService.getPainReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pain reading.", ex);
		}
	}

	@Override
	public Long savePulseOximetryReading(PulseOximetryReadingDTO pulseOximetryDTO) throws MHVException {
		
		ResponseUtil<Long> response = null;
		
		try {
			response = this.pulseOximetryService.save(pulseOximetryDTO);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pulse oximetry reading.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public void deletePulseOximetryReading(Long userProfileId, Long id) throws MHVException {
		try {
			this.pulseOximetryService.delete(id);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while deleting the pulse oximetry reading.", ex);
		}
	}

	@Override
	public List<PulseOximetryReadingDTO> getPulseOximetryReadingsForUser(Long userProfileId) throws MHVException {
		
		ResponseUtil<List<PulseOximetryReadingDTO>> response = null;
		
		try {
			response = this.pulseOximetryService.getPulseOximetryReadingsForUser(userProfileId);
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pulse oximetry readings.", ex);
		}
		
		if(response.isFailure()) {
			throw new MHVException(response);
		}
		
		return response.getPojoObject();
	}

	@Override
	public PulseOximetryReadingDTO getPulseOximetryReadingByid(Long userProfileId, Long id) throws MHVException {
		try {
			return this.pulseOximetryService.getPulseOximetryReadingByid(userProfileId, id).getPojoObject();
		} catch (Exception ex) {
			throw new MHVException("An unexpected error occured while getting the pulse oximetry reading.", ex);
		}
	}
	
}
